import { EnhancedEventEmitter } from './EnhancedEventEmitter';
import { Channel } from './Channel';
import { TransportProtocol } from './Transport';
import { WebRtcTransport } from './WebRtcTransport';
import { AppData } from './types';
export type WebRtcServerOptions<WebRtcServerAppData extends AppData = AppData> = {
    /**
     * Listen infos.
     */
    listenInfos: WebRtcServerListenInfo[];
    /**
     * Custom application data.
     */
    appData?: WebRtcServerAppData;
};
export type WebRtcServerListenInfo = {
    /**
     * Network protocol.
     */
    protocol: TransportProtocol;
    /**
     * Listening IPv4 or IPv6.
     */
    ip: string;
    /**
     * Announced IPv4 or IPv6 (useful when running mediasoup behind NAT with
     * private IP).
     */
    announcedIp?: string;
    /**
     * Listening port.
     */
    port?: number;
};
export type WebRtcServerEvents = {
    workerclose: [];
    '@close': [];
};
export type WebRtcServerObserverEvents = {
    close: [];
    webrtctransporthandled: [WebRtcTransport];
    webrtctransportunhandled: [WebRtcTransport];
};
type WebRtcServerInternal = {
    webRtcServerId: string;
};
export declare class WebRtcServer<WebRtcServerAppData extends AppData = AppData> extends EnhancedEventEmitter<WebRtcServerEvents> {
    #private;
    /**
     * @private
     */
    constructor({ internal, channel, appData }: {
        internal: WebRtcServerInternal;
        channel: Channel;
        appData?: WebRtcServerAppData;
    });
    /**
     * WebRtcServer id.
     */
    get id(): string;
    /**
     * Whether the WebRtcServer is closed.
     */
    get closed(): boolean;
    /**
     * App custom data.
     */
    get appData(): WebRtcServerAppData;
    /**
     * App custom data setter.
     */
    set appData(appData: WebRtcServerAppData);
    /**
     * Observer.
     */
    get observer(): EnhancedEventEmitter<WebRtcServerObserverEvents>;
    /**
     * @private
     * Just for testing purposes.
     */
    get webRtcTransportsForTesting(): Map<string, WebRtcTransport>;
    /**
     * Close the WebRtcServer.
     */
    close(): void;
    /**
     * Worker was closed.
     *
     * @private
     */
    workerClosed(): void;
    /**
     * Dump WebRtcServer.
     */
    dump(): Promise<any>;
    /**
     * @private
     */
    handleWebRtcTransport(webRtcTransport: WebRtcTransport): void;
}
export {};
//# sourceMappingURL=WebRtcServer.d.ts.map